/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import java.io.Serializable;

public final class PredicateIndicator
implements Comparable<PredicateIndicator>,
Serializable {
    private final String functor;
    private final int arity;
    private final int hash;
    private final Atom ns;

    public PredicateIndicator(String functor, int arity) {
        this(Literal.DefaultNS, functor, arity);
    }

    public PredicateIndicator(Atom ns, String functor, int arity) {
        this.functor = functor;
        this.arity = arity;
        this.ns = ns;
        this.hash = this.calcHash();
    }

    public String getFunctor() {
        return this.functor;
    }

    public int getArity() {
        return this.arity;
    }

    public Atom getNS() {
        return this.ns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof PredicateIndicator && o.hashCode() == this.hashCode()) {
            PredicateIndicator pi2 = (PredicateIndicator)o;
            return this.arity == pi2.arity && this.functor.equals(pi2.functor) && this.ns.equals(pi2.ns);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(PredicateIndicator pi2) {
        int c = this.ns.compareTo(pi2.ns);
        if (c != 0) {
            return c;
        }
        c = this.functor.compareTo(pi2.functor);
        if (c != 0) {
            return c;
        }
        if (pi2.arity > this.arity) {
            return -1;
        }
        if (this.arity > pi2.arity) {
            return 1;
        }
        return 0;
    }

    private int calcHash() {
        int t = 31 * this.arity * this.ns.hashCode();
        if (this.functor != null) {
            t = 31 * t + this.functor.hashCode();
        }
        return t;
    }

    public String toString() {
        if (this.ns == Literal.DefaultNS) {
            return this.functor + "/" + this.arity;
        }
        return this.ns + "::" + this.functor + "/" + this.arity;
    }
}

