/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CyclicTerm
extends LiteralImpl {
    private static final long serialVersionUID = 1L;
    private VarTerm cyclicVar = null;

    public CyclicTerm(Literal t, VarTerm v) {
        super(t);
        this.cyclicVar = v;
    }

    public CyclicTerm(Literal t, VarTerm v, Unifier u) {
        super(t, u);
        this.cyclicVar = v;
    }

    @Override
    public VarTerm getCyclicVar() {
        return this.cyclicVar;
    }

    @Override
    public boolean isCyclicTerm() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof CyclicTerm) {
            CyclicTerm l = (CyclicTerm)o;
            return super.equals(l);
        }
        return false;
    }

    @Override
    public Literal makeVarsAnnon(Unifier u) {
        super.makeVarsAnnon(u);
        VarTerm v = u.deref(this.cyclicVar);
        if (v != null) {
            this.cyclicVar = v;
        }
        return this;
    }

    @Override
    public Term capply(Unifier u) {
        Term v = u.remove(this.cyclicVar);
        CyclicTerm r = new CyclicTerm((Literal)this, (VarTerm)this.cyclicVar.clone(), u);
        if (v != null) {
            u.bind(this.cyclicVar, v);
        }
        return r;
    }

    @Override
    public Term clone() {
        return new CyclicTerm((Literal)this, (VarTerm)this.cyclicVar.clone());
    }

    @Override
    protected int calcHashCode() {
        return super.calcHashCode() + this.cyclicVar.calcHashCode();
    }

    @Override
    public String toString() {
        return "..." + super.toString() + "/" + this.cyclicVar;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = super.getAsDOM(document);
        u.setAttribute("cyclic-var", this.cyclicVar.toString());
        return u;
    }
}

