/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Atom
extends Literal {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Atom.class.getName());
    private final String functor;
    private final Atom ns;

    public Atom(String functor) {
        this(DefaultNS, functor);
    }

    protected Atom(Atom namespace2, String functor) {
        if (functor == null) {
            logger.log(Level.WARNING, "The functor of an atom functor should not be null!", new Exception());
        }
        this.functor = functor;
        this.ns = namespace2;
    }

    public Atom(Literal l) {
        this(l.getNS(), l);
    }

    public Atom(Literal l, Unifier u) {
        this((Atom)l.getNS().capply(u), l);
    }

    public Atom(Atom namespace2, Literal l) {
        this.functor = l.getFunctor();
        this.ns = namespace2;
        this.srcInfo = l.srcInfo;
    }

    @Override
    public String getFunctor() {
        return this.functor;
    }

    @Override
    public Atom getNS() {
        return this.ns;
    }

    @Override
    public Term clone() {
        return this;
    }

    @Override
    public Term capply(Unifier u) {
        if (this.ns.isVar()) {
            return new Atom((Literal)this, u);
        }
        return this;
    }

    @Override
    public Literal cloneNS(Atom newnamespace) {
        return new Atom(newnamespace, this);
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Atom) {
            Atom a = (Atom)o;
            return a.isAtom() && this.getFunctor().equals(a.getFunctor()) && this.getNS().equals(a.getNS());
        }
        return false;
    }

    @Override
    public int compareTo(Term t) {
        if (t == null) {
            return -1;
        }
        if (t.isNumeric()) {
            return 1;
        }
        if (this.isList() && !t.isList()) {
            return -1;
        }
        if (!this.isList() && t.isList()) {
            return 1;
        }
        if (this.isList() && t.isList()) {
            int l2s;
            ListTerm l1 = (ListTerm)((Object)this);
            ListTerm l2 = (ListTerm)t;
            int l1s = l1.size();
            if (l1s > (l2s = l2.size())) {
                return 1;
            }
            if (l2s > l1s) {
                return -1;
            }
            return 0;
        }
        if (t.isVar()) {
            return -1;
        }
        if (t instanceof Literal) {
            Literal tAsLit = (Literal)t;
            if (this.getNS().equals(tAsLit.getNS())) {
                int oa;
                int ma = this.getArity();
                if (ma < (oa = tAsLit.getArity())) {
                    return -1;
                }
                if (ma > oa) {
                    return 1;
                }
                return this.getFunctor().compareTo(tAsLit.getFunctor());
            }
            return this.getNS().compareTo(tAsLit.getNS());
        }
        return super.compareTo(t);
    }

    @Override
    protected int calcHashCode() {
        return this.getFunctor().hashCode() + this.getNS().hashCode();
    }

    public String toString() {
        if (this.ns == DefaultNS) {
            return this.functor;
        }
        return this.getNS() + "::" + this.functor;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("structure");
        u.setAttribute("functor", this.getFunctor());
        u.setAttribute("name-space", this.getNS().getFunctor());
        return u;
    }
}

