/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.NoValueException;
import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.ArithFunctionTerm;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Term;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArithExpr
extends ArithFunctionTerm
implements NumberTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ArithExpr.class.getName());
    private ArithmeticOp op = ArithmeticOp.none;

    public ArithExpr(NumberTerm t1, ArithmeticOp oper, NumberTerm t2) {
        super(oper.toString(), 2);
        this.addTerm(t1);
        this.addTerm(t2);
        this.op = oper;
        this.srcInfo = t1.getSrcInfo() != null ? t1.getSrcInfo() : t2.getSrcInfo();
    }

    public ArithExpr(ArithmeticOp oper, NumberTerm t1) {
        super(oper.toString(), 1);
        this.addTerm(t1);
        this.op = oper;
        this.srcInfo = t1.getSrcInfo();
    }

    private ArithExpr(ArithExpr ae) {
        super(ae);
        this.op = ae.op;
    }

    public static NumberTerm parseExpr(String sExpr) {
        return ArithExpr.parseExpr(null, sExpr);
    }

    public static NumberTerm parseExpr(Agent ag, String sExpr) {
        as2j parser = new as2j(new StringReader(sExpr));
        if (ag != null) {
            parser.setAg(ag);
        }
        try {
            return (NumberTerm)parser.arithm_expr();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing expression " + sExpr, e2);
            return null;
        }
    }

    @Override
    public Term capply(Unifier u) {
        try {
            double l = ((NumberTerm)this.getTerm(0).capply(u)).solve();
            if (this.isUnary()) {
                this.value = this.op == ArithmeticOp.minus ? new NumberTermImpl(-l) : new NumberTermImpl(l);
            } else {
                double r = ((NumberTerm)this.getTerm(1).capply(u)).solve();
                this.value = new NumberTermImpl(this.op.eval(l, r));
            }
            return this.value;
        }
        catch (ClassCastException e2) {
            logger.warning("The value of " + this + " is not a number! Unifier = " + u + ". Code: " + this.getSrcInfo());
            return new NumberTermImpl(Double.NaN);
        }
        catch (NoValueException e3) {
            return this.clone();
        }
    }

    @Override
    public boolean checkArity(int a) {
        return a == 1 || a == 2;
    }

    @Override
    public NumberTerm clone() {
        return new ArithExpr(this);
    }

    public ArithmeticOp getOp() {
        return this.op;
    }

    public NumberTerm getLHS() {
        return (NumberTerm)this.getTerm(0);
    }

    public NumberTerm getRHS() {
        return (NumberTerm)this.getTerm(1);
    }

    @Override
    public String toString() {
        if (this.isUnary()) {
            return "(" + (Object)((Object)this.op) + this.getTerm(0) + ")";
        }
        return "(" + this.getTerm(0) + (Object)((Object)this.op) + this.getTerm(1) + ")";
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("expression");
        u.setAttribute("type", "arithmetic");
        u.setAttribute("operator", this.op.toString());
        if (this.isUnary()) {
            Element r = document.createElement("right");
            r.appendChild(this.getTerm(0).getAsDOM(document));
            u.appendChild(r);
        } else {
            Element l = document.createElement("left");
            l.appendChild(this.getTerm(0).getAsDOM(document));
            u.appendChild(l);
            Element r = document.createElement("right");
            r.appendChild(this.getTerm(1).getAsDOM(document));
            u.appendChild(r);
        }
        return u;
    }

    public static enum ArithmeticOp {
        none{

            @Override
            double eval(double x, double y) {
                return 0.0;
            }

            public String toString() {
                return "";
            }
        }
        ,
        plus{

            @Override
            double eval(double x, double y) {
                return x + y;
            }

            public String toString() {
                return "+";
            }
        }
        ,
        minus{

            @Override
            double eval(double x, double y) {
                return x - y;
            }

            public String toString() {
                return "-";
            }
        }
        ,
        times{

            @Override
            double eval(double x, double y) {
                return x * y;
            }

            public String toString() {
                return "*";
            }
        }
        ,
        div{

            @Override
            double eval(double x, double y) {
                return x / y;
            }

            public String toString() {
                return "/";
            }
        }
        ,
        mod{

            @Override
            double eval(double x, double y) {
                return x % y;
            }

            public String toString() {
                return " mod ";
            }
        }
        ,
        pow{

            @Override
            double eval(double x, double y) {
                return Math.pow(x, y);
            }

            public String toString() {
                return "**";
            }
        }
        ,
        intdiv{

            @Override
            double eval(double x, double y) {
                return (int)x / (int)y;
            }

            public String toString() {
                return " div ";
            }
        };


        abstract double eval(double var1, double var3);
    }
}

