/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSemantics.Agent;
import jason.asSemantics.QueryCacheKey;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.PredicateIndicator;
import jason.profiling.QueryProfiling;
import jason.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class QueryCacheAdv {
    private Agent ag;
    private Map<PredicateIndicator, List<Pair<Literal, List<Unifier>>>> cache = null;
    private Map<PredicateIndicator, List<Pair<Literal, List<Unifier>>>> tmp = null;
    private Set<QueryCacheKey> noCache = null;
    private QueryProfiling prof;
    protected Logger logger = null;

    public QueryCacheAdv(Agent ag, QueryProfiling p) {
        this.ag = ag;
        this.prof = p;
        this.logger = Logger.getLogger(QueryCacheAdv.class.getName() + "-" + ag.getTS().getUserAgArch().getAgName());
        this.cache = new HashMap<PredicateIndicator, List<Pair<Literal, List<Unifier>>>>();
        this.tmp = new HashMap<PredicateIndicator, List<Pair<Literal, List<Unifier>>>>();
        this.noCache = new HashSet<QueryCacheKey>();
    }

    public void reset() {
        this.cache.clear();
        this.tmp.clear();
        this.noCache.clear();
    }

    public Pair<Literal, Iterator<Unifier>> getCache(Literal f) {
        List<Pair<Literal, List<Unifier>>> optsTmp;
        List<Pair<Literal, List<Unifier>>> opts = this.cache.get(f.getPredicateIndicator());
        if (opts != null) {
            for (Pair<Literal, List<Unifier>> ic : opts) {
                if (!new Unifier().unifies(f, ic.getFirst()) || !ic.getFirst().subsumes(f)) continue;
                if (this.prof != null) {
                    this.prof.incHits();
                }
                return new Pair<Literal, Iterator<Unifier>>(ic.getFirst(), ic.getSecond().iterator());
            }
        }
        if ((optsTmp = this.tmp.get(f.getPredicateIndicator())) != null && !this.noCache.contains(new QueryCacheKey(f))) {
            for (Pair<Literal, List<Unifier>> ic : optsTmp) {
                if (!new Unifier().unifies(f, ic.getFirst()) || !ic.getFirst().subsumes(f)) continue;
                if (this.prof != null) {
                    this.prof.incHits();
                }
                final Literal lTmp = ic.getFirst();
                final List<Unifier> listTmp = ic.getSecond();
                final int listSize = listTmp.size();
                this.noCache.add(new QueryCacheKey(lTmp));
                return new Pair<Literal, Iterator<Unifier>>(lTmp, new Iterator<Unifier>(){
                    Iterator<Unifier> i = null;
                    int iTmp = 0;
                    boolean fromTmp = true;

                    @Override
                    public boolean hasNext() {
                        boolean hn;
                        boolean bl = hn = this.iTmp < listSize;
                        if (hn) {
                            return true;
                        }
                        if (this.fromTmp) {
                            this.fromTmp = false;
                            this.i = lTmp.logicalConsequence(QueryCacheAdv.this.ag, new Unifier());
                            for (int c = 0; c < listSize; ++c) {
                                this.i.next();
                            }
                        }
                        boolean bl2 = hn = this.i != null && this.i.hasNext();
                        if (!hn) {
                            QueryCacheAdv.this.queryFinished(lTmp);
                        }
                        return hn;
                    }

                    @Override
                    public Unifier next() {
                        if (this.fromTmp) {
                            return (Unifier)listTmp.get(this.iTmp++);
                        }
                        Unifier a = this.i.next();
                        listTmp.add(a);
                        return a;
                    }

                    @Override
                    public void remove() {
                    }
                });
            }
        }
        return null;
    }

    public void addAnswer(Literal f, Unifier a) {
        if (this.noCache.contains(new QueryCacheKey(f))) {
            return;
        }
        List<Unifier> ans = null;
        List<Pair<Literal, List<Unifier>>> opts = this.tmp.get(f.getPredicateIndicator());
        if (opts == null) {
            opts = new ArrayList<Pair<Literal, List<Unifier>>>();
            this.tmp.put(f.getPredicateIndicator(), opts);
        } else {
            for (Pair<Literal, List<Unifier>> ic : opts) {
                if (!f.equals(ic.getFirst())) continue;
                ans = ic.getSecond();
                break;
            }
        }
        if (ans == null) {
            ans = new ArrayList<Unifier>();
            opts.add(new Pair(f, ans));
        }
        ans.add(a);
    }

    public void queryFinished(Literal f) {
        List<Pair<Literal, List<Unifier>>> opts = this.tmp.get(f.getPredicateIndicator());
        if (opts != null) {
            Iterator<Pair<Literal, List<Unifier>>> i = opts.iterator();
            while (i.hasNext()) {
                Pair<Literal, List<Unifier>> ic = i.next();
                if (!f.equals(ic.getFirst())) continue;
                i.remove();
                List<Pair<Literal, List<Unifier>>> optsCache = this.cache.get(f.getPredicateIndicator());
                if (optsCache == null) {
                    optsCache = new ArrayList<Pair<Literal, List<Unifier>>>();
                    this.cache.put(f.getPredicateIndicator(), optsCache);
                }
                optsCache.add(ic);
                return;
            }
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("In cache:\n");
        for (List<Pair<Literal, List<Unifier>>> q : this.cache.values()) {
            for (Pair<Literal, List<Unifier>> ic : q) {
                out.append("  " + ic.getFirst() + ": " + ic.getSecond() + "\n");
            }
        }
        out.append("In cache (but not finished):\n");
        for (List<Pair<Literal, List<Unifier>>> q : this.tmp.values()) {
            for (Pair<Literal, List<Unifier>> ic : q) {
                out.append("  " + ic.getFirst() + ": " + ic.getSecond() + "\n");
            }
        }
        return out.toString();
    }
}

