/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSemantics.Circumstance;
import jason.asSemantics.Event;
import jason.asSemantics.IntendedMeans;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.PlanLibrary;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.util.Pair;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Intention
implements Serializable,
Comparable<Intention>,
Iterable<IntendedMeans> {
    private static final long serialVersionUID = 1L;
    public static final Intention EmptyInt = null;
    private static AtomicInteger idCount = new AtomicInteger(0);
    private int id;
    private int atomicCount = 0;
    private boolean isSuspended = false;
    private Deque<IntendedMeans> intendedMeans = new ArrayDeque<IntendedMeans>();

    public Intention() {
        this.id = idCount.incrementAndGet();
    }

    public int getId() {
        return this.id;
    }

    public void push(IntendedMeans im) {
        this.intendedMeans.push(im);
        if (im.isAtomic()) {
            ++this.atomicCount;
        }
    }

    public IntendedMeans peek() {
        return this.intendedMeans.peek();
    }

    public IntendedMeans pop() {
        IntendedMeans top = this.intendedMeans.pop();
        if (this.isAtomic() && top.isAtomic()) {
            --this.atomicCount;
        }
        return top;
    }

    public boolean isAtomic() {
        return this.atomicCount > 0;
    }

    public void setAtomic(int a) {
        this.atomicCount = a;
    }

    @Override
    public Iterator<IntendedMeans> iterator() {
        return this.intendedMeans.iterator();
    }

    public boolean isFinished() {
        return this.intendedMeans.isEmpty();
    }

    public int size() {
        return this.intendedMeans.size();
    }

    public void clearIM() {
        this.intendedMeans.clear();
    }

    public void setSuspended(boolean b) {
        this.isSuspended = b;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public IntendedMeans getIM(Trigger g, Unifier u) {
        for (IntendedMeans im : this.intendedMeans) {
            if (!u.unifies(g, im.getTrigger())) continue;
            return im;
        }
        return null;
    }

    public IntendedMeans getBottom() {
        return this.intendedMeans.getLast();
    }

    public boolean hasTrigger(Trigger g, Unifier u) {
        for (IntendedMeans im : this.intendedMeans) {
            if (!u.unifies(g, im.getTrigger())) continue;
            return true;
        }
        return false;
    }

    public boolean dropGoal(Trigger te, Unifier un) {
        boolean r = false;
        IntendedMeans im = this.getIM(te, un);
        while (im != null) {
            r = true;
            while (this.peek() != im) {
                this.pop();
            }
            this.pop();
            im = this.getIM(te, un);
        }
        return r;
    }

    public void fail(Circumstance c) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Event, Integer> findEventForFailure(Trigger tevent, PlanLibrary pl, Circumstance c) {
        Trigger failTrigger = new Trigger(Trigger.TEOperator.del, tevent.getType(), tevent.getLiteral());
        Iterator<IntendedMeans> ii = this.iterator();
        int posInStak = this.size();
        Object object = pl.getLock();
        synchronized (object) {
            while (!pl.hasCandidatePlan(failTrigger) && ii.hasNext()) {
                IntendedMeans im = ii.next();
                tevent = im.getTrigger();
                failTrigger = new Trigger(Trigger.TEOperator.del, tevent.getType(), tevent.getLiteral());
                --posInStak;
            }
            if (tevent.isGoal() && tevent.isAddition() && pl.hasCandidatePlan(failTrigger)) {
                return new Pair<Event, Integer>(new Event(failTrigger.clone(), this), posInStak);
            }
            return new Pair<Object, Integer>(null, 0);
        }
    }

    @Override
    public int compareTo(Intention o) {
        if (o.atomicCount > this.atomicCount) {
            return 1;
        }
        if (this.atomicCount > o.atomicCount) {
            return -1;
        }
        if (o.id > this.id) {
            return 1;
        }
        if (this.id > o.id) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Intention) {
            return ((Intention)o).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public Intention clone() {
        Intention i = new Intention();
        i.id = this.id;
        i.atomicCount = this.atomicCount;
        i.intendedMeans = new ArrayDeque<IntendedMeans>();
        for (IntendedMeans im : this.intendedMeans) {
            i.intendedMeans.add((IntendedMeans)im.clone());
        }
        return i;
    }

    public void copyTo(Intention i) {
        i.atomicCount = this.atomicCount;
        i.intendedMeans = new ArrayDeque<IntendedMeans>(this.intendedMeans);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("intention " + this.id + ": \n");
        int i = 0;
        for (IntendedMeans im : this.intendedMeans) {
            s.append("    " + im + "\n");
            if (i++ <= 40) continue;
            s.append("... more " + (this.size() - 40) + " intended means!\n");
            break;
        }
        if (this.isFinished()) {
            s.append("<finished intention>");
        }
        return s.toString();
    }

    public Term getAsTerm() {
        Structure intention = new Structure("intention");
        intention.addTerm(new NumberTermImpl(this.getId()));
        ListTermImpl lt = new ListTermImpl();
        for (IntendedMeans im : this.intendedMeans) {
            lt.add(im.getAsTerm());
        }
        intention.addTerm(lt);
        return intention;
    }

    public Element getAsDOM(Document document) {
        Element eint = document.createElement("intention");
        eint.setAttribute("id", this.id + "");
        for (IntendedMeans im : this.intendedMeans) {
            eint.appendChild(im.getAsDOM(document));
        }
        eint.setAttribute("finished", "" + this.isFinished());
        eint.setAttribute("suspended", "" + this.isSuspended());
        return eint;
    }
}

