/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSemantics.Option;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanBodyImpl;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IntendedMeans
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Unifier unif = null;
    protected PlanBody planBody;
    protected Plan plan;
    private Trigger trigger;
    protected Unifier renamedVars = null;

    public IntendedMeans(Option opt, Trigger te) {
        this.plan = opt.getPlan();
        this.planBody = this.plan.getBody();
        this.unif = opt.getUnifier();
        this.trigger = te == null ? this.plan.getTrigger().capply(this.unif) : te.capply(this.unif);
    }

    private IntendedMeans() {
    }

    public Term removeCurrentStep() {
        if (this.isFinished()) {
            return null;
        }
        Term r = this.planBody.getBodyTerm();
        this.planBody = this.planBody.getBodyNext();
        return r;
    }

    public PlanBody getCurrentStep() {
        return this.planBody;
    }

    public PlanBody insertAsNextStep(PlanBody pb2add) {
        this.planBody = new PlanBodyImpl(this.planBody.getBodyType(), this.planBody.getBodyTerm());
        this.planBody.setBodyNext(pb2add);
        return this.planBody;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setUnif(Unifier unif) {
        this.unif = unif;
    }

    public Unifier getUnif() {
        return this.unif;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger tr) {
        this.trigger = tr;
    }

    public boolean isAtomic() {
        return this.plan != null && this.plan.isAtomic();
    }

    public boolean isFinished() {
        return this.planBody == null || this.planBody.isEmptyBody();
    }

    public boolean isGoalAdd() {
        return this.trigger.isAddition() && this.trigger.isGoal();
    }

    public Object clone() {
        IntendedMeans c = new IntendedMeans();
        c.unif = this.unif.clone();
        if (this.planBody != null) {
            c.planBody = this.planBody.clonePB();
        }
        c.trigger = this.trigger.clone();
        c.plan = this.plan;
        return c;
    }

    public String toString() {
        return this.trigger + " <- " + (this.planBody == null ? "." : "... " + this.planBody) + " / " + this.unif;
    }

    public Term getAsTerm() {
        if (this.planBody instanceof PlanBodyImpl || this.planBody == null) {
            PlanBody bd = this.planBody == null ? new PlanBodyImpl() : (PlanBody)((Object)((PlanBodyImpl)this.planBody.clone()).makeVarsAnnon());
            bd.setAsBodyTerm(true);
            return ASSyntax.createStructure("im", ASSyntax.createString(this.plan.getLabel()), bd, this.unif.getAsTerm());
        }
        return ASSyntax.createAtom("noimplementedforclass" + this.planBody.getClass().getSimpleName());
    }

    public Element getAsDOM(Document document) {
        Element eim = document.createElement("intended-means");
        eim.setAttribute("trigger", this.trigger.toString());
        if (this.planBody != null) {
            eim.appendChild(this.planBody.getAsDOM(document));
        }
        if (this.unif != null && this.unif.size() > 0) {
            eim.appendChild(this.unif.getAsDOM(document));
        }
        return eim;
    }
}

