/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSemantics.Event;
import jason.asSemantics.GoalListener;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Trigger;

public class GoalListenerForMetaEvents
implements GoalListener {
    private TransitionSystem ts;

    public GoalListenerForMetaEvents(TransitionSystem ts) {
        this.ts = ts;
    }

    @Override
    public void goalStarted(Event goal) {
        this.generateGoalStateEvent(goal.getTrigger().getLiteral(), Trigger.TEType.achieve, GoalListener.GoalStates.started, null);
    }

    @Override
    public void goalFailed(Trigger goal) {
        this.generateGoalStateEvent(goal.getLiteral(), goal.getType(), GoalListener.GoalStates.failed, null);
    }

    @Override
    public void goalFinished(Trigger goal, GoalListener.FinishStates result) {
        this.generateGoalStateEvent(goal.getLiteral(), goal.getType(), GoalListener.GoalStates.finished, result.toString());
    }

    @Override
    public void goalResumed(Trigger goal) {
        this.generateGoalStateEvent(goal.getLiteral(), goal.getType(), GoalListener.GoalStates.resumed, null);
    }

    @Override
    public void goalSuspended(Trigger goal, String reason) {
        this.generateGoalStateEvent(goal.getLiteral(), goal.getType(), GoalListener.GoalStates.suspended, reason);
    }

    private void generateGoalStateEvent(final Literal goal, final Trigger.TEType type, final GoalListener.GoalStates state, final String reason) {
        this.ts.runAtBeginOfNextCycle(new Runnable(){

            @Override
            public void run() {
                Literal newGoal = goal.forceFullLiteralImpl().copy();
                Literal stateAnnot = ASSyntax.createLiteral("state", new Atom(state.toString()));
                if (reason != null) {
                    stateAnnot.addAnnot(ASSyntax.createStructure("reason", new StringTermImpl(reason)));
                }
                newGoal.addAnnot(stateAnnot);
                Trigger eEnd = new Trigger(Trigger.TEOperator.goalState, type, newGoal);
                if (GoalListenerForMetaEvents.this.ts.getAg().getPL().hasCandidatePlan(eEnd)) {
                    GoalListenerForMetaEvents.this.ts.getC().insertMetaEvent(new Event(eEnd, null));
                }
            }
        });
        this.ts.getUserAgArch().wakeUpDeliberate();
    }
}

