/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.JasonException;
import jason.asSemantics.Agent;
import jason.asSemantics.Circumstance;
import jason.asSemantics.Intention;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public abstract class ConcurrentInternalAction
implements InternalAction {
    private static AtomicInteger actcount = new AtomicInteger(0);

    @Override
    public boolean canBeUsedInContext() {
        return false;
    }

    @Override
    public boolean suspendIntention() {
        return true;
    }

    @Override
    public Term[] prepareArguments(Literal body, Unifier un) {
        Term[] terms = new Term[body.getArity()];
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = body.getTerm(i).capply(un);
        }
        return terms;
    }

    @Override
    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        return false;
    }

    public String suspendInt(final TransitionSystem ts, String basekey, int timeout) {
        final String key = basekey + "/" + actcount.incrementAndGet();
        final Circumstance C = ts.getC();
        Intention i = C.getSelectedIntention();
        i.setSuspended(true);
        C.addPendingIntention(key, i);
        if (timeout > 0) {
            Agent.getScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    if (C.getPendingIntentions().get(key) != null) {
                        ConcurrentInternalAction.this.timeout(ts, key);
                    }
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        }
        return key;
    }

    public void startInternalAction(TransitionSystem ts, Runnable code) {
        Agent.getScheduler().execute(code);
    }

    public abstract void timeout(TransitionSystem var1, String var2);

    public void resumeInt(TransitionSystem ts, String intentionKey) {
        ConcurrentInternalAction.resume(ts, intentionKey, false, null);
    }

    public void failInt(TransitionSystem ts, String intentionKey) {
        ConcurrentInternalAction.resume(ts, intentionKey, true, JasonException.createBasicErrorAnnots("fail_resume", "Error resuming pending intention"));
    }

    public static synchronized void resume(final TransitionSystem ts, final String intentionKey, final boolean abort, final List<Term> failAnnots) {
        ts.runAtBeginOfNextCycle(new Runnable(){

            @Override
            public void run() {
                Circumstance C = ts.getC();
                Intention pi2 = C.removePendingIntention(intentionKey);
                if (pi2 != null) {
                    pi2.setSuspended(false);
                    try {
                        if (abort) {
                            ts.generateGoalDeletion(pi2, failAnnots);
                        } else {
                            pi2.peek().removeCurrentStep();
                            ts.applyClrInt(pi2);
                            C.resumeIntention(pi2);
                        }
                    }
                    catch (JasonException e2) {
                        ts.getLogger().log(Level.SEVERE, "Error resuming intention", e2);
                    }
                }
            }
        });
        ts.getUserAgArch().wakeUpDeliberate();
    }

    @Override
    public void destroy() throws Exception {
    }
}

