/*
 * Decompiled with CFR 0.152.
 */
package jason.architecture;

import jason.architecture.AgArchInfraTier;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Message;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.Literal;
import jason.infra.centralised.CentralisedAgArch;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class AgArch
implements AgArchInfraTier,
Comparable<AgArch> {
    private TransitionSystem ts = null;
    private AgArch successor = null;
    private AgArch firstArch = this;
    private int cycleNumber = 0;

    public void init() throws Exception {
    }

    public void stop() {
        if (this.successor != null) {
            this.successor.stop();
        }
    }

    public AgArch getFirstAgArch() {
        return this.firstArch;
    }

    public AgArch getNextAgArch() {
        return this.successor;
    }

    public List<String> getAgArchClassesChain() {
        ArrayList<String> all = new ArrayList<String>();
        for (AgArch a = this.getFirstAgArch(); a != null; a = a.getNextAgArch()) {
            all.add(0, a.getClass().getName());
        }
        return all;
    }

    public void insertAgArch(AgArch arch) {
        if (arch != this.firstArch) {
            arch.successor = this.firstArch;
        }
        if (this.ts != null) {
            arch.ts = this.ts;
            this.ts.setAgArch(arch);
        }
        this.setFirstAgArch(arch);
    }

    private void setFirstAgArch(AgArch arch) {
        this.firstArch = arch;
        if (this.successor != null) {
            this.successor.setFirstAgArch(arch);
        }
    }

    public void createCustomArchs(List<String> archs) throws Exception {
        if (archs == null) {
            return;
        }
        for (String agArchClass : archs) {
            if (agArchClass.equals(AgArch.class.getName()) || agArchClass.equals(CentralisedAgArch.class.getName())) continue;
            try {
                AgArch a = (AgArch)Class.forName(agArchClass).newInstance();
                a.setTS(this.ts);
                this.insertAgArch(a);
                a.init();
            }
            catch (Exception e2) {
                System.out.println("Error creating custom agent aarchitecture." + e2);
                e2.printStackTrace();
                this.ts.getLogger().log(Level.SEVERE, "Error creating custom agent aarchitecture.", e2);
            }
        }
    }

    public void reasoningCycleStarting() {
        if (this.successor != null) {
            this.successor.reasoningCycleStarting();
        }
    }

    public AgArchInfraTier getArchInfraTier() {
        if (this.successor == null) {
            return this;
        }
        return this.successor.getArchInfraTier();
    }

    public TransitionSystem getTS() {
        if (this.ts != null) {
            return this.ts;
        }
        if (this.successor != null) {
            return this.successor.getTS();
        }
        return null;
    }

    public void setTS(TransitionSystem ts) {
        this.ts = ts;
        if (this.successor != null) {
            this.successor.setTS(ts);
        }
    }

    @Override
    public Collection<Literal> perceive() {
        if (this.successor == null) {
            return null;
        }
        return this.successor.perceive();
    }

    @Override
    public void checkMail() {
        if (this.successor != null) {
            this.successor.checkMail();
        }
    }

    @Override
    public void act(ActionExec action) {
        if (this.successor != null) {
            this.successor.act(action);
        }
    }

    public void actionExecuted(ActionExec act) {
        this.getTS().getC().addFeedbackAction(act);
        this.wakeUpAct();
    }

    @Override
    public boolean canSleep() {
        return this.successor == null || this.successor.canSleep();
    }

    @Override
    public void wake() {
        if (this.successor != null) {
            this.successor.wake();
        }
    }

    public void wakeUpSense() {
        if (this.successor != null) {
            this.successor.wakeUpSense();
        }
    }

    public void wakeUpDeliberate() {
        if (this.successor != null) {
            this.successor.wakeUpDeliberate();
        }
    }

    public void wakeUpAct() {
        if (this.successor != null) {
            this.successor.wakeUpAct();
        }
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        if (this.successor == null) {
            return null;
        }
        return this.successor.getRuntimeServices();
    }

    @Override
    public String getAgName() {
        if (this.successor == null) {
            return "no-named";
        }
        return this.successor.getAgName();
    }

    @Override
    public void sendMsg(Message m) throws Exception {
        if (this.successor != null) {
            this.successor.sendMsg(m);
        }
    }

    @Override
    public void broadcast(Message m) throws Exception {
        if (this.successor != null) {
            this.successor.broadcast(m);
        }
    }

    @Override
    public boolean isRunning() {
        return this.successor == null || this.successor.isRunning();
    }

    public void setCycleNumber(int cycle) {
        this.cycleNumber = cycle;
        if (this.successor != null) {
            this.successor.setCycleNumber(cycle);
        }
    }

    public void incCycleNumber() {
        this.setCycleNumber(this.cycleNumber + 1);
    }

    public int getCycleNumber() {
        return this.cycleNumber;
    }

    public String toString() {
        return "arch-" + this.getAgName();
    }

    public int hashCode() {
        return this.getAgName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AgArch) {
            return this.getAgName().equals(((AgArch)obj).getAgName());
        }
        return false;
    }

    @Override
    public int compareTo(AgArch o) {
        return this.getAgName().compareTo(o.getAgName());
    }
}

